package de.heise.newsticker.android;

import java.util.ArrayList;
import java.util.List;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;

public class HeiseOnlineAdapter extends BaseAdapter {

	private Context context;
	private int rowResID;
	private List<News> newsListe;

	public HeiseOnlineAdapter(Context context, int rowResID) {

		this.context = context;
		this.rowResID = rowResID;
		this.newsListe = getNews();

	}

	public List<News> getNews() {
		// String keywords = null;
		HttpEntity entity = null;
		Document doc = null;
		HttpClient client = new DefaultHttpClient();
		HttpGet get = new HttpGet("/newsticker/heise-atom.xml");
		ArrayList<News> news = new ArrayList<News>();
		HttpHost target = new HttpHost("www.heise.de", 80, "http");

		Log.d("TEST", target.toHostString());

		try {
			HttpResponse response = client.execute(target, get);
			entity = response.getEntity();
			// keywords = EntityUtils.toString(entity);
			// Log.d("TEST", keywords);

		} catch (Exception e) {
			e.printStackTrace();
		} // finally {
		// if (entity != null)
		// try {
		// entity.consumeContent();
		// } catch (IOException e) {
		//
		// }
		// }

		try {

			DocumentBuilderFactory factory = DocumentBuilderFactory
					.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			doc = builder.parse(entity.getContent());
			NodeList alleNews = doc.getElementsByTagName("entry");

			Log.d("TEST", "Alle News" + alleNews.getLength());

			if (alleNews != null) {

				int len1 = alleNews.getLength();

				for (int i = 0; i < len1; i++) {

					Node eineNews = alleNews.item(i);

					if (eineNews != null) {
						NodeList nodeList = eineNews.getChildNodes();

						Log.d("TEST", "Eine News " + nodeList.getLength());

						News neu = new News();

						int len = nodeList.getLength();

						for (int a = 0; a < len; a++) {
							Node node = nodeList.item(a);
							String value = this.getNodeValue(node);

							Log.d("TEST", "Name:  " + node.getNodeName());
							Log.d("TEST", "Value:  " + value);

							if ("title".equals(node.getNodeName())) {
								neu.setTitle(value);
							} else if ("id".equals(node.getNodeName())) {
								neu.setUrl(value);
							} else if ("summary".equals(node.getNodeName())) {
								neu.setBody(value);
							} else if ("updated".equals(node.getNodeName())) {
								neu.setDate(value);
							}

						}

						news.add(neu);
					}

				}
			}

		} catch (Exception e) {

		}

		return news;
	}

	@Override
	public int getCount() {
		return newsListe.size();

	}

	@Override
	public Object getItem(int position) {
		return newsListe.get(position);

	}

	@Override
	public long getItemId(int position) {
		return position;

	}

	@Override
	public View getView(int position, View convertView, ViewGroup parent) {

		News news = newsListe.get(position);
		LayoutInflater inflate = LayoutInflater.from(context);

		View v = inflate.inflate(rowResID, null);
		TextView newsTitle = (TextView) v.findViewById(R.id.title);
		if (newsTitle != null)
			newsTitle.setText(news.getTitle());

		TextView newsBody = (TextView) v.findViewById(R.id.body);
		if (newsBody != null)
			newsBody.setText(news.getBody());

		TextView newsUrl = (TextView) v.findViewById(R.id.url);
		if (newsUrl != null)
			newsUrl.setText(news.getUrl());

		return v;

	}

	private String getNodeValue(Node node) {
		NodeList children = node.getChildNodes();
		if (children.getLength() > 0) {
			return children.item(0).getNodeValue();
		} else
			return null;
	}

}
